/*
 * Created on 10 janv. 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.injac.cocoon.generators;

import java.io.IOException;
import java.util.Map;

import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.FileGenerator;
import org.apache.excalibur.source.SourceException;
import org.apache.log4j.Category;
import org.xml.sax.SAXException;

/**
 * @author shoam
 *
 * Use login and password parameters for identified webdav file access 
 */
public class WebdavFileGenerator extends FileGenerator {
	private String showsrc;
	private String login;
	private String password;
	/**
	 * Static logger
	 */
	static Category cat = Category.getInstance(WebdavFileGenerator.class.getName());

    /**
     * Setup the file generator.
     * Try to get the last modification date of the source for caching.
     */
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par)
        throws ProcessingException, SAXException, IOException {

        super.setup(resolver, objectModel, src, par);
        cat.debug("connect to src "+src);
        showsrc=src;
        String uri = src.substring(9);
        try {
			login=par.getParameter("login");
			password=par.getParameter("password");
			src = "webdav://"+login+":"+password+"@"+uri;
		}
		catch(Exception e)
		{
			login=null;
			password=null;
			src=showsrc;
		}
		cat.info("SRC = "+src);
        try {
            this.inputSource = super.resolver.resolveURI(src);
        } catch (SourceException se) {
            throw SourceUtil.handle("Error during resolving of '" + showsrc + "'.", se);
        }
    }

}
